package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.activities.GameWebViewScreen;
import com.ElyStudio.leGaou.models.Games;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.util.List;

public class TrendingGamesAdapter extends RecyclerView.Adapter<TrendingGamesAdapter.TrendingGamesViewHolder> {

    private List<Games> trendingGamesList;
    private Context context;
    private Activity activity;
    private int adEnabled;
    private String interstitialAdId;


    public TrendingGamesAdapter(List<Games> trendingGamesList, Context context, Activity activity, int adEnabled, String interstitialAdId) {
        this.trendingGamesList = trendingGamesList;
        this.context = context;
        this.activity = activity;
        this.adEnabled = adEnabled;
        this.interstitialAdId = interstitialAdId;
    }

    private InterstitialAd mInterstitialAd;

    public final static String TAG = "TRENDING_GAME_ADAPTER";


    @NonNull
    @Override
    public TrendingGamesAdapter.TrendingGamesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new TrendingGamesViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.trending_game_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull TrendingGamesAdapter.TrendingGamesViewHolder holder, int position) {
        loadInterstitialAd();
        Games games = trendingGamesList.get(position);
        int textColor;
        int bgColor;

        holder.gameName.setText(games.getName());

        if(games.getColorCode() == 1)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_1);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_1);
        }
        else if(games.getColorCode() == 2)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_2);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_2);
        }
        else if(games.getColorCode() == 3)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_3);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_3);
        }
        else if(games.getColorCode() == 4)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_4);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_4);
        }
        else if(games.getColorCode() == 5)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_5);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_5);
        }
        else if(games.getColorCode() == 6)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_6);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_6);
        }
        else if(games.getColorCode() == 7)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_7);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_7);
        }
        else if(games.getColorCode() == 8)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_8);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_8);
        }
        else
        {
            textColor = context.getResources().getColor(R.color.primary_text_color);
            bgColor = context.getResources().getColor(R.color.quiz_color_bg_default);
        }

        if(!games.getIcon().trim().equals(""))
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL+games.getIcon()).into(holder.gameIcon);
        }

        holder.gameCard.setCardBackgroundColor(bgColor);
        holder.playGameBtn.setBackgroundColor(textColor);
        holder.gameName.setTextColor(textColor);

        holder.playGameBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                    if(mInterstitialAd != null)
                    {
                        mInterstitialAd.show(activity);
                        mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                            @Override
                            public void onAdDismissedFullScreenContent() {
                                super.onAdDismissedFullScreenContent();
                                startGame(games);
                            }
                        });
                    }
                    else
                    {
                        startGame(games);
                    }
            }
        });

    }

    @Override
    public int getItemCount() {
        return trendingGamesList.size();
    }

    public static class TrendingGamesViewHolder extends RecyclerView.ViewHolder {
        ImageView gameIcon;
        TextView gameName;
        MaterialCardView gameCard;
        Button playGameBtn;
        public TrendingGamesViewHolder(@NonNull View itemView) {
            super(itemView);

            gameIcon = itemView.findViewById(R.id.gameIcon);
            gameName = itemView.findViewById(R.id.trendingGameName);
            gameCard = itemView.findViewById(R.id.trendingGameCard);
            playGameBtn = itemView.findViewById(R.id.playGameBtn);

        }
    }

    private void loadInterstitialAd(){

        if(adEnabled == 1)
        {
            AdRequest adRequest = new AdRequest.Builder().build();

            InterstitialAd.load(context, interstitialAdId, adRequest, new InterstitialAdLoadCallback() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG,"Failed to load interstitial ad = "+loadAdError);
                    mInterstitialAd = null;
                }

                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                }
            });
        }

    }

    private void startGame(Games games){
        Intent intent = new Intent(context, GameWebViewScreen.class);
        intent.putExtra(Constants.gameUrl,games.getGameUrl());
        intent.putExtra(Constants.gameName,games.getName());
        intent.putExtra(Constants.adEnabled,adEnabled);
        intent.putExtra(Constants.interstitialAdId,interstitialAdId);
        context.startActivity(intent);
    }
}
